/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigFolderNode;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class VWConfigTreeCellRender
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private boolean renderExportImportTree = false;

    public VWConfigTreeCellRender() {
        this.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int nRow, boolean bHasFocus) {
        super.getTreeCellRendererComponent(tree, value, bSelected, bExpanded, bLeaf, nRow, bHasFocus);
        VWConfigBaseNode baseNode = (VWConfigBaseNode)value;
        this.setToolTipText(baseNode.getDescription());
        switch (baseNode.getType()) {
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (bExpanded) {
                    this.setIcon(((VWConfigFolderNode)value).getOpenIcon16());
                    break;
                }
                this.setIcon(((VWConfigFolderNode)value).getClosedIcon16());
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: {
                this.setIcon(baseNode.getIcon16());
            }
        }
        this.setBorder(null);
        this.setText(baseNode.getName());
        VWAccessibilityHelper.setAccessibility(this, null, this.getText(), this.getText());
        if (bSelected) {
            if (bHasFocus) {
                this.setForeground(SystemColor.textHighlightText);
                this.setBackground(SystemColor.textHighlight);
                this.setBorder(new LineBorder(SystemColor.windowBorder));
            } else {
                this.setBackground(SystemColor.menu);
                this.setForeground(SystemColor.textText);
                this.setBorder(new LineBorder(SystemColor.windowBorder));
            }
        } else {
            this.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
            this.setBorder(new LineBorder(tree.getBackground()));
        }
        return this;
    }

    public void renderToExportImpotTree(boolean bOpt) {
        this.renderExportImportTree = bOpt;
    }
}

